﻿''' <summary>
''' Form de edição de dados relativos aos Vencimentos, subsídios de refeição, dias trabalhados, dias de férias ou faltas num determinado mês
''' </summary>
''' <remarks></remarks>
Public Class frmMês
    Dim intDiasTotaisMês As Integer
    Dim intDiasÚteis As Integer
    Dim strMês As String ' Mês actual ou "Férias" ou "Natal"
    Dim bolFimLoad As Boolean = False ' Indica que já acabou de fazer load, pelo que o programa (ou consultas) já pode aceder a todos os objectos da form

    ''' <summary>
    ''' Rotina executada quando carrega a Form.
    ''' Selecciona o dia actual e formata no calendário 
    ''' A seguir carrega os valores relativos ao mês actual para a tabela
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub frmMês_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            strMês = Today.Month.ToString
            calMês.SelectDate(Today)
            subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
            subCarregaValoresMês(calMês.ActiveMonth.Month)
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            btnMêsCorrente.Enabled = False
            btnMêsCorrente.BackColor = Color.Aqua
            btnSubsídioNatal.Enabled = True
            btnSubsídioNatal.BackColor = Color.WhiteSmoke
            btnSubsídioFérias.Enabled = True
            btnSubsídioFérias.BackColor = Color.WhiteSmoke
            calMês.Visible = Not btnMêsCorrente.Enabled
            subFormataTabela()
            bolFimLoad = True
        End Try
    End Sub
    ''' <summary>
    ''' O utilizador alterou o data no calendário
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub calMês_MonthChanged(ByVal sender As System.Object, ByVal e As Pabo.Calendar.MonthChangedEventArgs) Handles calMês.MonthChanged
        Try
            If bolFimLoad Then
                subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
                subCarregaValoresMês(strMês)
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    Private Sub dgvDias_CellValueChanged(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles dgvDias.CellValueChanged
        subFormataTabela()
    End Sub

    ''' <summary>
    ''' Quando o utilizador manda gravar, primeiro validamos os dados por ele introduzimos, caso sejam válidos, damos uma instrução ao SQL para actualizar caso existam as linhas ou inserir caso não existam
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnGravar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGravar.Click
        Try
            subFormataTabela()
            If funTestaValores() Then
                Dim x As Integer

                For Each row As DataGridViewRow In dgvDias.Rows
                    If row.Index <> -1 And Not row.IsNewRow Then
                        'IF EXISTS (SELECT * FROM Table1 WHERE Column1='SomeValue')
                        'UPDATE Table1 SET (...) WHERE Column1='SomeValue'
                        'Else
                        'INSERT INTO Table1 VALUES (...)
                        Dim strComandoSQL As String = "IF EXISTS (SELECT * FROM Mês WHERE "
                        strComandoSQL += "NúmeroFuncionário='" & row.Cells(colNúmero.Index).Value.ToString & "' AND "
                        strComandoSQL += "Ano='" & calMês.ActiveMonth.Year.ToString & "' AND "
                        If strMês = "Férias" Then
                            strComandoSQL += "Mês.Mês='14') " ' 14º Mês
                        ElseIf strMês = "Natal" Then
                            strComandoSQL += "Mês.Mês='13') " ' 13º Mês
                        Else
                            strComandoSQL += "Mês.Mês='" & calMês.ActiveMonth.Month.ToString("00") & "') "
                        End If
                        strComandoSQL += "UPDATE Mês SET "
                        strComandoSQL += "VencimentoBase=Convert(real," & row.Cells(colVencimento.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & "), "
                        strComandoSQL += "SubRefeição=Convert(real," & row.Cells(colSubRefeição.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & "), "
                        strComandoSQL += "DiasMês='" & Int(row.Cells(colDiasMês.Index).Value) & "', "
                        strComandoSQL += "DiasSubRefeição='" & Int(row.Cells(colDiasSubRefeição.Index).Value) & "', "
                        strComandoSQL += "DiasFérias='" & Int(row.Cells(colDiasFérias.Index).Value) & "', "
                        strComandoSQL += "DiasBaixa='" & Int(row.Cells(colDiasBaixa.Index).Value) & "', "
                        strComandoSQL += "DiasFaltas='" & Int(row.Cells(colDiasFaltas.Index).Value) & "', "
                        strComandoSQL += "TaxaIRS=Convert(real," & row.Cells(colTaxaIRS.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & ") "
                        strComandoSQL += "WHERE ("
                        strComandoSQL += "NúmeroFuncionário='" & row.Cells(colNúmero.Index).Value.ToString & "'AND "
                        strComandoSQL += "Ano='" & calMês.ActiveMonth.Year.ToString & "' AND "
                        If strMês = "Férias" Then
                            strComandoSQL += "Mês.Mês='14') " ' 14º Mês
                        ElseIf strMês = "Natal" Then
                            strComandoSQL += "Mês.Mês='13') " ' 13º Mês
                        Else
                            strComandoSQL += "Mês.Mês='" & calMês.ActiveMonth.Month.ToString("00") & "') "
                        End If
                        strComandoSQL += "ELSE "
                        strComandoSQL += "INSERT INTO Mês VALUES ("
                        strComandoSQL += "'" & row.Cells(colNúmero.Index).Value.ToString & "', "
                        strComandoSQL += "'" & calMês.ActiveMonth.Year.ToString & "', "
                        If strMês = "Férias" Then
                            strComandoSQL += "'14', " ' 14º Mês
                        ElseIf strMês = "Natal" Then
                            strComandoSQL += "'13', " ' 13º Mês
                        Else
                            strComandoSQL += "'" & calMês.ActiveMonth.Month.ToString("00") & "', "
                        End If
                        strComandoSQL += "Convert(real," & row.Cells(colVencimento.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & "), "
                        strComandoSQL += "Convert(real," & row.Cells(colSubRefeição.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & "), "
                        strComandoSQL += "'" & Int(row.Cells(colDiasMês.Index).Value) & "', "
                        strComandoSQL += "'" & Int(row.Cells(colDiasSubRefeição.Index).Value) & "', "
                        strComandoSQL += "'" & Int(row.Cells(colDiasFérias.Index).Value) & "', "
                        strComandoSQL += "'" & Int(row.Cells(colDiasBaixa.Index).Value) & "', "
                        strComandoSQL += "'" & Int(row.Cells(colDiasFaltas.Index).Value) & "', "
                        strComandoSQL += "Convert(real," & row.Cells(colTaxaIRS.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & ")) "

                        Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
                        Dim execCommand As New SqlCommand(strComandoSQL, sqlConn)
                        sqlConn.Open()
                        x = execCommand.ExecuteNonQuery
                        sqlConn.Close()
                        sqlConn = Nothing
                        execCommand = Nothing
                        strComandoSQL = Nothing
                    End If
                Next
                subCarregaValoresMês(strMês)
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' O utilizador carregou em cancelar, ignora todos os dados alterados e carrega os dados existentes
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnCancelar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancelar.Click
        subCarregaValoresMês(strMês)
    End Sub
    ''' <summary>
    ''' Valores relativos ao mês corrente
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnMêsCorrente_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMêsCorrente.Click
        Try
            strMês = calMês.ActiveMonth.Month.ToString
            calMês.SelectDate(Today)
            subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
            subCarregaValoresMês(Today.Month.ToString)
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            btnMêsCorrente.Enabled = False
            btnMêsCorrente.BackColor = Color.Aqua
            btnSubsídioNatal.Enabled = True
            btnSubsídioNatal.BackColor = Color.WhiteSmoke
            btnSubsídioFérias.Enabled = True
            btnSubsídioFérias.BackColor = Color.WhiteSmoke
            calMês.Visible = Not btnMêsCorrente.Enabled
            subFormataTabela()
        End Try
    End Sub
    ''' <summary>
    ''' Valores relativos ao Subsídio de Férias
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnSubsídioFérias_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSubsídioFérias.Click
        Try
            subCarregaValoresMês("Férias")
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            strMês = "Férias"
            btnMêsCorrente.Enabled = True
            btnMêsCorrente.BackColor = Color.WhiteSmoke
            btnSubsídioNatal.Enabled = True
            btnSubsídioNatal.BackColor = Color.WhiteSmoke
            btnSubsídioFérias.Enabled = False
            btnSubsídioFérias.BackColor = Color.Aqua
            calMês.Visible = Not btnMêsCorrente.Enabled
            subFormataTabela()
        End Try
    End Sub
    ''' <summary>
    ''' Valores relativos ao Subsídio de Natal
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnSubsídioNatal_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSubsídioNatal.Click
        Try
            subCarregaValoresMês("Natal")
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            strMês = "Natal"
            btnMêsCorrente.Enabled = True
            btnMêsCorrente.BackColor = Color.WhiteSmoke
            btnSubsídioNatal.Enabled = False
            btnSubsídioNatal.BackColor = Color.Aqua
            btnSubsídioFérias.Enabled = True
            btnSubsídioFérias.BackColor = Color.WhiteSmoke
            calMês.Visible = Not btnMêsCorrente.Enabled
            subFormataTabela()
        End Try
    End Sub


    ''' <summary>
    ''' Valida os valores introduzidos para não dar erro no envio para o SQL
    ''' </summary>
    ''' <returns>Retorna True se todos os dados estiverem correctos</returns>
    ''' <remarks></remarks>
    Private Function funTestaValores() As Boolean
        Try
            Dim bolTestaDiasMês As Boolean = True
            Dim bolTestaDiasSubRefeição As Boolean = True
            Dim bolTestaDiasFérias As Boolean = True
            Dim bolTestaDiasBaixa As Boolean = True
            Dim bolTestaDiasFaltas As Boolean = True

            For Each row As DataGridViewRow In dgvDias.Rows
                row.DefaultCellStyle.ForeColor = Color.Black
                If row.Index <> -1 And Not row.IsNewRow Then
                    row.Cells(colVencimento.Index).Value = row.Cells(colVencimento.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "")
                    row.Cells(colSubRefeição.Index).Value = row.Cells(colSubRefeição.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "")
                    row.Cells(colTaxaIRS.Index).Value = row.Cells(colTaxaIRS.Index).Value.ToString.Replace("€", "").Replace("%", "").Replace(" ", "")

                    If IsNumeric(row.Cells(colVencimento.Index).Value) Then
                        If Int(row.Cells(colVencimento.Index).Value) < 0 Then
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("Valor do Vencimento Base do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "É negativo!", MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                    Else
                        row.DefaultCellStyle.ForeColor = Color.Red
                        MsgBox("O valor do Vencimento Base do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "Não é um número!", MsgBoxStyle.Critical, "Não é possível gravar!")
                        Return False
                    End If
                    If IsNumeric(row.Cells(colSubRefeição.Index).Value) Then
                        If Int(row.Cells(colSubRefeição.Index).Value) < 0 Then
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("Valor do Subsídio de Refeição do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & " É negativo!", MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                    Else
                        row.DefaultCellStyle.ForeColor = Color.Red
                        MsgBox("O valor do Subsídio de Refeição do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "Não é um número!", MsgBoxStyle.Critical, "Não é possível gravar!")
                        Return False
                    End If
                    If IsNumeric(strMês) Then
                        If IsNumeric(row.Cells(colDiasMês.Index).Value) Then
                            If Int(row.Cells(colDiasMês.Index).Value) < 0 Then
                                row.DefaultCellStyle.ForeColor = Color.Red
                                MsgBox("Número de Dias do Mês no funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "É negativo!", MsgBoxStyle.Critical, "Não é possível gravar!")
                                Return False
                            End If
                            If Int(row.Cells(colDiasMês.Index).Value) > intDiasTotaisMês Then
                                Dim intResposta As Integer = MsgBox("Número de Total de Dias do Mês no funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & " É maior que a realidade do mês: " & intDiasTotaisMês.ToString, MsgBoxStyle.YesNo, "Tem a certeza que quer gravar?")
                                If intResposta = vbNo Then
                                    row.DefaultCellStyle.ForeColor = Color.Red
                                    Return False
                                End If
                                bolTestaDiasMês = False
                            End If
                        Else
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("O valor do Días do Mês do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "Não é um número!", MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                    Else
                        If IsNumeric(row.Cells(colDiasMês.Index).Value) Then
                            If Int(row.Cells(colDiasMês.Index).Value) < 1 OrElse Int(row.Cells(colDiasMês.Index).Value) > 12 Then
                                row.DefaultCellStyle.ForeColor = Color.Red
                                MsgBox("Número Mêses no funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "Impossível!", MsgBoxStyle.Critical, "Não é possível gravar!")
                                Return False
                            End If
                        Else
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("O valor do Mês: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "Não é um número!", MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                    End If
                    If IsNumeric(row.Cells(colDiasSubRefeição.Index).Value) Then
                        If Int(row.Cells(colDiasSubRefeição.Index).Value) < 0 Then
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("Número de Dias de Subsídio de Refeição do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & " É negativo!", MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                        If row.Cells(colDiasSubRefeição.Index).Value > intDiasÚteis Then
                            Dim intResposta As Integer = MsgBox("Número de Dias de Subsídio de Refeição do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & " É maior que número de dias úteis do mês: " & intDiasÚteis.ToString, MsgBoxStyle.YesNo, "Tem a certeza que quer gravar?")
                            If intResposta = vbNo Then
                                row.DefaultCellStyle.ForeColor = Color.Red
                                Return False
                            End If
                            bolTestaDiasSubRefeição = False
                        End If
                    Else
                        row.DefaultCellStyle.ForeColor = Color.Red
                        MsgBox("O valor do Días de Subsídio de Refeição do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "Não é um número!", MsgBoxStyle.Critical, "Não é possível gravar!")
                        Return False
                    End If
                    If IsNumeric(row.Cells(colDiasFérias.Index).Value) Then
                        If Int(row.Cells(colDiasFérias.Index).Value) < 0 Then
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("Número de Dias de Férias do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "É negativo!", MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                        If Int(row.Cells(colDiasFérias.Index).Value) > intDiasÚteis Then
                            Dim intResposta As Integer = MsgBox("Número de Dias de Férias do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & " É maior que número de dias úteis do mês: " & intDiasÚteis.ToString, MsgBoxStyle.YesNo, "Tem a certeza que quer gravar?")
                            If intResposta = vbNo Then
                                row.DefaultCellStyle.ForeColor = Color.Red
                                Return False
                            End If
                            bolTestaDiasFérias = False
                        End If
                    Else
                        row.DefaultCellStyle.ForeColor = Color.Red
                        MsgBox("O valor do Días de Férias do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "Não é um número!", MsgBoxStyle.Critical, "Não é possível gravar!")
                        Return False
                    End If
                    If IsNumeric(row.Cells(colDiasBaixa.Index).Value) Then
                        If Int(row.Cells(colDiasBaixa.Index).Value) < 0 Then
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("Número de Dias de Baixa do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "É negativo!", MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                        If Int(row.Cells(colDiasBaixa.Index).Value) > intDiasTotaisMês Then
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("Número de Dias de Baixa do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & " É maior que número de dias totais do mês: " & intDiasÚteis.ToString, MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                    Else
                        row.DefaultCellStyle.ForeColor = Color.Red
                        MsgBox("O valor do Días de Baixa do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "Não é um número!", MsgBoxStyle.Critical, "Não é possível gravar!")
                        Return False
                    End If
                    If IsNumeric(row.Cells(colDiasFaltas.Index).Value) Then
                        If Int(row.Cells(colDiasFaltas.Index).Value) < 0 Then
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("Número de Dias de Faltas do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "É negativo!", MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                        If Int(row.Cells(colDiasFaltas.Index).Value) > intDiasÚteis Then
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("Número de Dias de Faltas do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & " É maior que número de dias úteis do mês: " & intDiasÚteis.ToString, MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                    Else
                        row.DefaultCellStyle.ForeColor = Color.Red
                        MsgBox("O valor do Días de Faltas do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "Não é um número!", MsgBoxStyle.Critical, "Não é possível gravar!")
                        Return False
                    End If
                    If IsNumeric(row.Cells(colTaxaIRS.Index).Value) Then
                        If Convert.ToSingle(row.Cells(colTaxaIRS.Index).Value) < 0 Then
                            row.DefaultCellStyle.ForeColor = Color.Red
                            MsgBox("Valor da Taxa de IRS do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "É negativo!", MsgBoxStyle.Critical, "Não é possível gravar!")
                            Return False
                        End If
                        Dim irs As Single = Convert.ToSingle(row.Cells(colTaxaIRS.Index).Value)
                        If Convert.ToSingle(row.Cells(colTaxaIRS.Index).Value) > 1 Then
                            row.Cells(colTaxaIRS.Index).Value /= 100
                        End If
                    Else
                        row.DefaultCellStyle.ForeColor = Color.Red
                        MsgBox("O valor da Taxa de IRS do funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString & vbNewLine & "Não é um número!", MsgBoxStyle.Critical, "Não é possível gravar!")
                        Return False
                    End If

                    'Nesta altura todos os valores foram validados (são números) agora é só verificar que não há erros
                    If bolTestaDiasSubRefeição AndAlso bolTestaDiasFérias AndAlso Int(row.Cells(colDiasSubRefeição.Index).Value) + Int(row.Cells(colDiasFérias.Index).Value) > intDiasÚteis Then
                        MsgBox("Número de Dias de Subsídio de Refeição somado com número de Dias de Férias, é maior que o número de dias úteis do mês no funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString, MsgBoxStyle.Critical, "Não é possível gravar!")
                        row.DefaultCellStyle.ForeColor = Color.Red
                        Return False
                    End If
                    If bolTestaDiasSubRefeição AndAlso bolTestaDiasBaixa AndAlso Int(row.Cells(colDiasSubRefeição.Index).Value) + Int(row.Cells(colDiasBaixa.Index).Value) > intDiasTotaisMês Then
                        MsgBox("Número de Dias de Subsídio de Refeição somado com número de Dias de Baixa, é maior que o número de dias totais do mês no funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString, MsgBoxStyle.Critical, "Não é possível gravar!")
                        row.DefaultCellStyle.ForeColor = Color.Red
                        Return False
                    End If
                    If bolTestaDiasFérias AndAlso bolTestaDiasBaixa AndAlso Int(row.Cells(colDiasFérias.Index).Value) + Int(row.Cells(colDiasBaixa.Index).Value) > intDiasTotaisMês Then
                        MsgBox("Número de Dias de Férias somado com número de Dias de Baixa, é maior que o número de dias totais do mês no funcionário: " & vbNewLine & row.Cells(colNome.Index).Value.ToString, MsgBoxStyle.Critical, "Não é possível gravar!")
                        row.DefaultCellStyle.ForeColor = Color.Red
                        Return False
                    End If
                    ' TODO -> teste de soma entre dias de faltas e outros dias
                End If
            Next
            Return True
        Catch ex As Exception
            modLog.subErro(ex)
            Return False
        End Try
    End Function
    ''' <summary>
    ''' Carrega os valores dos funcionários relativos ao mês seleccionado no calendário.
    ''' Se não houver dados para este mês, tenta carregar para o mês anterior.
    ''' Se mesmo assim, não houver dados pergunta ao utilizador que ser criar dados para o presente mês.
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subCarregaValoresMês(ByVal Mês As String)
        Try
            dgvDias.Rows.Clear()
            ' Selecciona todos os funcionários que no Mês e Ano seleccionado eram funcionário (já tinham sido admitidos e não tinham rescindido)
            Dim strSelectFuncionáriosActivos As String = "SELECT * FROM Funcionários WHERE "
            If IsNumeric(Mês) Then
                strSelectFuncionáriosActivos += "AdmitidoEm<='" & calMês.ActiveMonth.Year.ToString() & calMês.ActiveMonth.Month.ToString("00") & System.DateTime.Now.DaysInMonth(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month).ToString() & "' AND "
            Else
                strSelectFuncionáriosActivos += "AdmitidoEm<='" & calMês.ActiveMonth.Year.ToString() & "1231' AND "
            End If
            strSelectFuncionáriosActivos += "(RescindiuAfirmativo='' OR "
            strSelectFuncionáriosActivos += "(RescindiuAfirmativo<>'' AND "
            If IsNumeric(Mês) Then
                strSelectFuncionáriosActivos += "RescindiuEm>='" & calMês.ActiveMonth.Year.ToString() & calMês.ActiveMonth.Month.ToString("00") & "01')) "
            Else
                strSelectFuncionáriosActivos += "RescindiuEm>='" & calMês.ActiveMonth.Year.ToString() & "0101')) "
            End If
            strSelectFuncionáriosActivos += "ORDER BY Funcionários.Nome ASC"

            Dim sqlConnSelectFuncionáriosActivos As New SqlConnection(Settings.strSQLConnection)
            Dim cmdSelectFuncionáriosActivos As New SqlCommand(strSelectFuncionáriosActivos, sqlConnSelectFuncionáriosActivos)
            sqlConnSelectFuncionáriosActivos.Open()

            ' Executa o comando colocando num SqlDataReader os resultados
            Dim readerSelectFuncionáriosActivos As SqlDataReader = cmdSelectFuncionáriosActivos.ExecuteReader()
            ' Caso existam rows (linhas)

            If readerSelectFuncionáriosActivos.HasRows Then
                ' Executa um ciclo nas linhas existentes mostrando o campo “username”
                While readerSelectFuncionáriosActivos.Read()
                    Dim strSelectDadosFuncionário As String = ""
                    strSelectDadosFuncionário += "IF EXISTS (SELECT NúmeroFuncionário, Ano, Mês FROM Mês WHERE "
                    strSelectDadosFuncionário += "NúmeroFuncionário='" & readerSelectFuncionáriosActivos.Item("NúmeroFuncionário").ToString.Trim & "' AND "
                    strSelectDadosFuncionário += "Ano='" & calMês.ActiveMonth.Year & "' AND "
                    If Mês = "Férias" Then
                        strSelectDadosFuncionário += "Mês.Mês='14') " ' 14º Mês
                    ElseIf Mês = "Natal" Then
                        strSelectDadosFuncionário += "Mês.Mês='13') " ' 13º Mês
                    Else
                        strSelectDadosFuncionário += "Mês.Mês='" & calMês.ActiveMonth.Month.ToString("00") & "') "
                    End If
                    'strSelectDadosFuncionário += "Mês='" & calMês.ActiveMonth.Month & "' ) "
                    strSelectDadosFuncionário += "SELECT * FROM Mês WHERE "
                    strSelectDadosFuncionário += "NúmeroFuncionário='" & readerSelectFuncionáriosActivos.Item("NúmeroFuncionário").ToString.Trim & "' AND "
                    strSelectDadosFuncionário += "Ano='" & calMês.ActiveMonth.Year & "' AND "
                    If Mês = "Férias" Then
                        strSelectDadosFuncionário += "Mês.Mês='14' " ' 14º Mês
                    ElseIf Mês = "Natal" Then
                        strSelectDadosFuncionário += "Mês.Mês='13' " ' 13º Mês
                    Else
                        strSelectDadosFuncionário += "Mês.Mês='" & calMês.ActiveMonth.Month.ToString("00") & "' "
                    End If
                    'strSelectDadosFuncionário += "Mês='" & calMês.ActiveMonth.Month & "'  "
                    strSelectDadosFuncionário += "ELSE "
                    strSelectDadosFuncionário += "IF EXISTS (SELECT NúmeroFuncionário, Ano, Mês FROM Mês WHERE "
                    strSelectDadosFuncionário += "NúmeroFuncionário='" & readerSelectFuncionáriosActivos.Item("NúmeroFuncionário").ToString.Trim & "' AND "
                    If IsNumeric(Mês) Then
                        If calMês.ActiveMonth.Month = 1 Then
                            strSelectDadosFuncionário += "Ano='" & (calMês.ActiveMonth.Year - 1) & "' AND "
                            strSelectDadosFuncionário += "Mês='12' ) "
                        Else
                            strSelectDadosFuncionário += "Ano='" & calMês.ActiveMonth.Year & "' AND "
                            strSelectDadosFuncionário += "Mês='" & (calMês.ActiveMonth.Month - 1) & "' ) "
                        End If
                    Else
                        strSelectDadosFuncionário += "Ano='" & calMês.ActiveMonth.Year & "' AND "
                        If Mês = "Férias" Then
                            strSelectDadosFuncionário += "Mês.Mês='8') " ' 14º Mês
                        ElseIf Mês = "Natal" Then
                            strSelectDadosFuncionário += "Mês.Mês='12') " ' 13º Mês
                        End If
                    End If
                    strSelectDadosFuncionário += "SELECT * FROM Mês WHERE "
                    strSelectDadosFuncionário += "NúmeroFuncionário='" & readerSelectFuncionáriosActivos.Item("NúmeroFuncionário").ToString.Trim & "' AND "
                    If IsNumeric(Mês) Then
                        If calMês.ActiveMonth.Month = 1 Then
                            strSelectDadosFuncionário += "Ano='" & (calMês.ActiveMonth.Year - 1) & "' AND "
                            strSelectDadosFuncionário += "Mês='12'  "
                        Else
                            strSelectDadosFuncionário += "Ano='" & calMês.ActiveMonth.Year & "' AND "
                            strSelectDadosFuncionário += "Mês='" & (calMês.ActiveMonth.Month - 1) & "'  "
                        End If
                    Else
                        strSelectDadosFuncionário += "Ano='" & calMês.ActiveMonth.Year & "' AND "
                        If Mês = "Férias" Then
                            strSelectDadosFuncionário += "Mês.Mês='8' " ' 14º Mês
                        ElseIf Mês = "Natal" Then
                            strSelectDadosFuncionário += "Mês.Mês='12' " ' 13º Mês
                        End If
                    End If

                    Dim sqlConnSelectDadosFuncionários As New SqlConnection(Settings.strSQLConnection)
                    Dim cmdSelectDadosFuncionários As New SqlCommand(strSelectDadosFuncionário, sqlConnSelectDadosFuncionários)
                    sqlConnSelectDadosFuncionários.Open()

                    ' Executa o comando colocando num SqlDataReader os resultados
                    Dim readerSelectDadosFuncionários As SqlDataReader = cmdSelectDadosFuncionários.ExecuteReader()
                    ' Caso existam rows (linhas)

                    Dim strNúmeroFuncionário As String = readerSelectFuncionáriosActivos.Item("NúmeroFuncionário").ToString.Trim
                    Dim strNome As String = readerSelectFuncionáriosActivos.Item("Nome").ToString.Trim

                    If readerSelectDadosFuncionários.HasRows Then
                        While readerSelectDadosFuncionários.Read
                            Dim sglVencimentoBase As Single = Convert.ToSingle(readerSelectDadosFuncionários.Item("VencimentoBase"))
                            Dim sglSubRefeição As Single = Convert.ToSingle(readerSelectDadosFuncionários("SubRefeição"))
                            Dim intDiasMês As Integer = Int(readerSelectDadosFuncionários("DiasMês"))
                            Dim intDiasSubRefeição As Integer = Int(readerSelectDadosFuncionários("DiasSubRefeição"))
                            Dim intDiasFérias As Integer = Int(readerSelectDadosFuncionários("DiasFérias"))
                            Dim intDiasBaixa As Integer = Int(readerSelectDadosFuncionários("DiasBaixa"))
                            Dim intDiasFaltas As Integer = Int(readerSelectDadosFuncionários("DiasFaltas"))
                            Dim sglTaxaIRS As Single = Convert.ToSingle(readerSelectDadosFuncionários("TaxaIRS")) ' / 100
                            ' TODO -> Corrigir o nº de diasdo mês quando for subsídio de natar ou de férias para o nº de meses completos trabalhados
                            If IsNumeric(Mês) Then
                                dgvDias.Rows.Add(strNúmeroFuncionário, strNome, sglVencimentoBase, sglSubRefeição, intDiasMês, intDiasSubRefeição, intDiasFérias, intDiasBaixa, intDiasFaltas, sglTaxaIRS)
                            Else
                                dgvDias.Rows.Add(strNúmeroFuncionário, strNome, sglVencimentoBase, 0.0, intDiasMês, 0.0, 0.0, 0.0, 0.0, sglTaxaIRS)
                            End If
                        End While
                    Else
                        ' TODO -> Corrigir o nº de diasdo mês quando for subsídio de natar ou de férias para o nº de meses completos trabalhados
                        If IsNumeric(Mês) Then
                            dgvDias.Rows.Add(strNúmeroFuncionário, strNome, 0.0, 0.0, intDiasTotaisMês, intDiasÚteis, 0, 0, 0, 0.0)
                        Else
                            dgvDias.Rows.Add(strNúmeroFuncionário, strNome, 0.0, 0.0, 0.0, 0.0, 0, 0, 0, 0.0)
                        End If

                    End If
                    sqlConnSelectDadosFuncionários.Close()
                    sqlConnSelectDadosFuncionários = Nothing
                    cmdSelectDadosFuncionários = Nothing
                End While
            End If

            ' Fecha a ligação e limpa as variáveis
            sqlConnSelectFuncionáriosActivos.Close()
            sqlConnSelectFuncionáriosActivos = Nothing
            cmdSelectFuncionáriosActivos = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            subFormataTabela()
        End Try
    End Sub
    ''' <summary>
    ''' Formata o calendário mediante se é Sábado, Domingo ou Feriado
    ''' E calcula o nº total de dias do mês e nº total de dias úteis do mês
    ''' </summary>
    ''' <param name="Ano"></param>
    ''' <param name="Mês"></param>
    ''' <remarks></remarks>
    Private Sub subFormataCalendário(ByVal Ano As Integer, ByVal Mês As Integer)
        Try
            intDiasTotaisMês = 30 ' Para efeitos de cálculos o mês tem sempre 30 dias System.DateTime.DaysInMonth(Ano, Mês)
            calMês.ResetDateInfo() ' Limpa as datas formatadas
            Dim dtData As DateTime = New DateTime(Ano, Mês, 1)
            Dim diaDatas As Pabo.Calendar.DateItem() = New Pabo.Calendar.DateItem(System.DateTime.DaysInMonth(Ano, Mês)) {}
            diaDatas.Initialize()
            intDiasÚteis = 0
            For i As Integer = 1 To System.DateTime.DaysInMonth(Ano, Mês)
                diaDatas(i) = New Pabo.Calendar.DateItem()
                If funDiaFeriado(dtData) = "" Then
                    ' Não é Feriado
                    If dtData.DayOfWeek = DayOfWeek.Saturday Then
                        ' É sábado
                        diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                        diaDatas(i).BackColor1 = Color.LightBlue
                    ElseIf dtData.DayOfWeek = DayOfWeek.Sunday Then
                        ' É Domingo
                        diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                        diaDatas(i).BackColor1 = Color.OrangeRed
                    Else
                        ' Não é feriado e é dia útil
                        intDiasÚteis += 1
                    End If
                Else
                    ' É feriado
                    diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                    diaDatas(i).BackColor1 = Color.Orange
                End If
                dtData = dtData.AddDays(1) ' Passa para o próximo dia
            Next
            calMês.AddDateInfo(diaDatas)
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Formata a tabela
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subFormataTabela()
        ' Se for 1 mês mostra umas coisas, se não foi mostra outras
        colSubRefeição.Visible = IsNumeric(strMês)
        colDiasSubRefeição.Visible = IsNumeric(strMês)
        colDiasFérias.Visible = IsNumeric(strMês)
        colDiasBaixa.Visible = IsNumeric(strMês)
        colDiasFaltas.Visible = IsNumeric(strMês)
        If Not IsNumeric(strMês) Then
            colDiasMês.HeaderText = "Nº Mês (1-12)"
        Else
            colDiasMês.HeaderText = "Dias Mês"
        End If

        ' Formata as colunas
        dgvDias.Columns(colVencimento.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
        dgvDias.Columns(colVencimento.Index).DefaultCellStyle.Format = "#,##0.00 €"
        dgvDias.Columns(colSubRefeição.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
        dgvDias.Columns(colSubRefeição.Index).DefaultCellStyle.Format = "#,##0.00 €"
        dgvDias.Columns(colDiasMês.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
        dgvDias.Columns(colDiasSubRefeição.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
        dgvDias.Columns(colDiasFérias.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
        dgvDias.Columns(colDiasBaixa.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
        dgvDias.Columns(colDiasFaltas.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
        dgvDias.Columns(colTaxaIRS.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
        dgvDias.Columns(colTaxaIRS.Index).DefaultCellStyle.Format = "#,##0.0 %"
    End Sub
End Class